% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tricolore.R
\name{TernaryDistance}
\alias{TernaryDistance}
\title{Distance Between Points in Ternary Coordinates}
\usage{
TernaryDistance(p, C)
}
\arguments{
\item{p}{A vector of ternary coordinates {p1, p2, p3}.}

\item{C}{n by 3 matrix of ternary coordinates {p1, p2, p3}_i for i=1,...,n.}
}
\value{
Vector of distances between coordinate p and all coordinates in C.
}
\description{
The distances between ternary coordinate p and a set of ternary coordinates C.
}
\examples{
p <- c(0.5, 0.2, 0.3)
C <- prop.table(matrix(runif(3*10), ncol = 3), 1)
tricolore:::TernaryDistance(p, C)

}
\references{
https://en.wikipedia.org/wiki/Barycentric_coordinate_system#Distance_between_points
}
\keyword{internal}
