% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranBin2.R
\name{ranBin2}
\alias{ranBin2}
\title{Sample pairs of correlated binary events}
\usage{
ranBin2(nRep, u, psi)
}
\arguments{
\item{nRep}{Number of simulated event pairs, positive integer.}

\item{u}{Mean event probabilities, expressed as a vector of length 2. E.g.
to simulate associated bivariate events with probabilities 80% and 30%, use
\code{u = c(0.8, 0.3)}.}

\item{psi}{Odds ratio, number. This parameter controls the strength of
association. Use \code{psi = 1} for no association. Values greater than 1
correspond to increasingly positive association between the two events,
and vice-versa.}
}
\value{
Matrix of events represented as 0s and 1s, with \code{nRep} rows
and 2 columns. The first column is the incidence of event 1.
}
\description{
This function is reproduced from the \code{binarySimCLF} package
on CRAN. The original package appears no longer to be maintained.
View the original source at:
 https://github.com/cran/binarySimCLF/blob/master/R/ranBin2.R
}
\examples{
probs <- c(0.8, 0.3)
s <- ranBin2(1000, probs, psi=0.2)  # 1000 pairs of outcomes
cor(s)  # Negatively correlated because psi < 1
colMeans(s)  # Event rates as expected
}
