% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efftox.R
\name{efftox_dtps}
\alias{efftox_dtps}
\title{Calculate dose-transition pathways for an EffTox study}
\usage{
efftox_dtps(dat, cohort_sizes, next_dose, ...)
}
\arguments{
\item{dat}{An instance of \code{\link{efftox_params}}, a list of EffTox
parameters. An example is yielded by \code{\link{efftox_parameters_demo}}.}

\item{cohort_sizes}{vector of future cohort sizes, i.e. positive integers.
E.g. Tot calculate paths for the the next cohort of two followed by the next
cohort of three, use \code{c(2, 3)}.}

\item{next_dose}{the dose-level to be given to the immediately next cohort.}

\item{...}{extra params passed to \code{rstan::sampling}.}
}
\value{
dose pathways in a \code{data.frame}.
}
\description{
Calculate dose-transition pathways for an EffTox study.
}
\examples{
# Calculate the paths for the first cohort of 3 in Thall et al 2014 example
dat <- efftox_parameters_demo()
\dontrun{
dtps1 <- efftox_dtps(dat = dat, cohort_sizes = c(3), next_dose = 1)
}
# To calculate future paths in a partially-observed trial
dat <- efftox_parameters_demo()
dat$doses = array(c(1,1,1))
dat$eff = array(c(0,0,0))
dat$tox = array(c(1,1,1))
dat$num_patients = 3
\dontrun{
dtps2 <- efftox_dtps(dat = dat, cohort_sizes = c(3), next_dose = 1)
}

}
\references{
Brock et al. (submitted 2017), Implementing the EffTox
Dose-Finding Design in the Matchpoint Trial.
}
\seealso{
\code{\link{efftox_params}}

\code{\link{efftox_parameters_demo}}
}
