% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lanzante.test.R
\name{lanzante.test}
\alias{lanzante.test}
\title{Lanzante's Test for Change Point Detection}
\usage{
lanzante.test(x, method = c("wilcox.test", "rrod.test"))
}
\arguments{
\item{x}{a vector of class "numeric" or a time series object of class "ts"}

\item{method}{the test method. Defaults to \code{"wilcox.test"}.}
}
\value{
A list with class "htest" and "cptest".
}
\description{
Performes a non-parametric test after Lanzante in order to test for a
shift in the central tendency of a time series. The null hypothesis,
no shift, is tested against the alternative, shift.
}
\details{
Let \eqn{X} denote a continuous random variable, then the following model
with a single shift (change-point) can be proposed:

\deqn{
  x_i = \left\{
      \begin{array}{lcl}
       \theta + \epsilon_i, & \qquad & i = 1, \ldots, m \\
       \theta + \Delta + \epsilon_i & \qquad & i = m + 1, \ldots, n \\
      \end{array} \right.}{%
  x[i] = \theta + \epsilon[i] for i = 1, ..., m and x[i] = \theta + \Delta
  + \epsilon_i for i = m + 1, ..., n}

with \eqn{\theta(\epsilon) = 0}. The null hypothesis, H:\eqn{\Delta = 0}
is tested against the alternative A:\eqn{\Delta \ne 0}{\delta != 0}.

First, the data are transformed into increasing ranks
and for each time-step the adjusted rank sum is computed:

\deqn{U_k = 2 \sum_{i=1}^k r_i - k \left(n + 1\right) \qquad k = 1, \ldots, n}{%
U[k] = 2 * \sum r_i - k (n + 1)   k = 1, ..., n}

The probable change point is located at the absolute maximum
of the statistic:

\deqn{m = k(\max |U_k|)}{m = k(max |P[k]|)}.

For \code{method = "wilcox.test"} the Wilcoxon-Mann-Whitney two-sample
test is performed, using \eqn{m} to split the series. Otherwise,
the robust rank-order distributional test (\code{\link{rrod.test}} is
performed.
}
\examples{
data(maxau) ; plot(maxau[,"s"])
s.res <- lanzante.test(maxau[,"s"])
n <- s.res$nobs
i <- s.res$estimate
s.1 <- mean(maxau[1:i,"s"])
s.2 <- mean(maxau[(i+1):n,"s"])
s <- ts(c(rep(s.1,i), rep(s.2,(n-i))))
tsp(s) <- tsp(maxau[,"s"])
lines(s, lty=2)
print(s.res)


data(PagesData) ; lanzante.test(PagesData)
}
\references{
Lanzante, J. R. (1996), Resistant, robust and non-parametric
techniques for the analysis of climate data: Theory and examples,
including applications to historical radiosonde station data,
\emph{Int. J. Clim.}, 16, 1197--1226.
}
\seealso{
\code{\link{pettitt.test}}
}
\keyword{htest}
\keyword{nonparametric}
\keyword{ts}
\keyword{univar}
