% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/json_writers.R
\name{write_panel}
\alias{write_panel}
\title{Write a plot object as a panel in a Trelliscope display}
\usage{
write_panel(plot_object, key, base_path, name, group = "common", width,
  height, jsonp = TRUE, split_layout = FALSE)
}
\arguments{
\item{plot_object}{a plot object to be written (can be trellis, ggplot2, or htmlwidget)}

\item{key}{a string identifying the panel key, which will be used as the panel file name and which the \code{panelKey} column of the cognostics data frame should point to}

\item{base_path}{the base directory of the trelliscope application}

\item{name}{name of the display that the panel belongs to}

\item{group}{group name of the display that the panel belongs to}

\item{width}{width in pixels of each panel}

\item{height}{height in pixels of each panel}

\item{jsonp}{should json for panel be jsonp (TRUE) or json (FALSE)?}

\item{split_layout}{boolean that determines if the layout is split into components like a facet_grid vs. individual panels like facet_wrap.  Only applies to ggplot2 plot objects.}
}
\description{
Write a plot object as a panel in a Trelliscope display
}
