% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node.R
\name{is_node}
\alias{is_node}
\title{Is \code{x} a node?}
\usage{
is_node(x)
}
\arguments{
\item{x}{\verb{[object]}

An object.}
}
\value{
\code{TRUE} if \code{x} is a \code{tree_sitter_node}, otherwise \code{FALSE}.
}
\description{
Checks if \code{x} is a \code{tree_sitter_node} or not.
}
\examples{
\dontshow{if (rlang::is_installed("treesitter.r")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
language <- treesitter.r::language()
parser <- parser(language)

text <- "fn <- function() { 1 + 1 }"
tree <- parser_parse(parser, text)
node <- tree_root_node(tree)

is_node(node)

is_node(1)
\dontshow{\}) # examplesIf}
}
