% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treeshap.R
\name{treeshap}
\alias{treeshap}
\title{Calculate SHAP values of a tree ensemble model.}
\usage{
treeshap(unified_model, x, interactions = FALSE, verbose = TRUE)
}
\arguments{
\item{unified_model}{Unified data.frame representation of the model created with a (model).unify function. A \code{\link{model_unified.object}} object.}

\item{x}{Observations to be explained. A \code{data.frame} or \code{matrix} object with the same columns as in the training set of the model. Keep in mind that objects different than \code{data.frame} or plain \code{matrix} will cause an error or unpredictable behavior.}

\item{interactions}{Whether to calculate SHAP interaction values. By default is \code{FALSE}. Basic SHAP values are always calculated.}

\item{verbose}{Whether to print progress bar to the console. Should be logical. Progress bar will not be displayed on Windows.}
}
\value{
A \code{\link{treeshap.object}} object (for single-output models) or \code{\link{treeshap_multioutput.object}}, which is a list of \code{\link{treeshap.object}} objects (for multi-output models). SHAP values can be accessed from \code{\link{treeshap.object}} with \code{$shaps}, and interaction values can be accessed with \code{$interactions}.
}
\description{
Calculate SHAP values and optionally SHAP Interaction values.
}
\examples{
\donttest{
library(xgboost)
data <- fifa20$data[colnames(fifa20$data) != 'work_rate']
target <- fifa20$target

# calculating simple SHAP values
param <- list(objective = "reg:squarederror", max_depth = 3)
xgb_model <- xgboost::xgboost(as.matrix(data), params = param, label = target,
                              nrounds = 20, verbose = FALSE)
unified_model <- xgboost.unify(xgb_model, as.matrix(data))
treeshap1 <- treeshap(unified_model, head(data, 3))
plot_contribution(treeshap1, obs = 1)
treeshap1$shaps

# It's possible to calcualte explanation over different part of the data set

unified_model_rec <- set_reference_dataset(unified_model, data[1:1000, ])
treeshap_rec <- treeshap(unified_model, head(data, 3))
plot_contribution(treeshap_rec, obs = 1)

# calculating SHAP interaction values
param2 <- list(objective = "reg:squarederror", max_depth = 7)
xgb_model2 <- xgboost::xgboost(as.matrix(data), params = param2, label = target, nrounds = 10)
unified_model2 <- xgboost.unify(xgb_model2, as.matrix(data))
treeshap2 <- treeshap(unified_model2, head(data, 3), interactions = TRUE)
treeshap2$interactions
}
}
\seealso{
\code{\link{xgboost.unify}} for \code{XGBoost models}
\code{\link{lightgbm.unify}} for \code{LightGBM models}
\code{\link{gbm.unify}} for \code{GBM models}
\code{\link{randomForest.unify}} for \code{randomForest models}
\code{\link{ranger.unify}} for \code{ranger models}
\code{\link{ranger_surv.unify}} for \code{ranger survival models}
}
