% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xy_grid.R
\name{xy_grid}
\alias{xy_grid}
\alias{xy_grid.default}
\alias{xy_grid.formula}
\alias{xy_grid.matrix}
\alias{xy_grid.data.frame}
\title{Create a Cartesian product from evenly spaced values of two variables}
\usage{
xy_grid(x, ...)

\method{xy_grid}{default}(x, y, grid.resolution = 51, col.names = NULL, ...)

\method{xy_grid}{formula}(x, data, grid.resolution = 51, ...)

\method{xy_grid}{matrix}(x, grid.resolution = 51, ...)

\method{xy_grid}{data.frame}(x, grid.resolution = 51, ...)
}
\arguments{
\item{x}{Either a numeric vector (if argument \code{y} is also specified),
a matrix-like object (e.g., a data frame), or two-variable formula of the
form \code{y ~ x}.}

\item{...}{Additional (optional) arguments. (Currently ignored.)}

\item{y}{A numeric vector representing the second variable (only required if
\code{x} is a numeric vector).}

\item{grid.resolution}{Integer specifying the number of equally-spaced values
to use for each numeric variable. For example, if \code{grid.resolution = k}, 
then the final data frame will have \code{k^2} rows (formed by a Cartesian
product).}

\item{col.names}{Optional vector of column names to use for the output
whenever both \code{x} and \code{y} are supplied.}

\item{data}{A data frame containing the variables specified in
\code{x} if \code{x} is a formula.}

\item{formula}{A two-variable formula of the form \code{y ~ x}. The response
(i.e., the variable on the left side of the formula) corresponds to the
second column of the output.}
}
\value{
A data frame representing the Cartesian product between equally
spaced values from each variable.
}
\description{
Create a Cartesian product from evenly spaced values of two variables.
}
\examples{
x1 <- 1:3
x2 <- letters[1L:3L]
xy_grid(x1, x2, gr = 3, col.names = c("x1", "x2"))  # will have 3^2=9 rows
xy_grid(m <- cbind(x1, x2), gr = 3)     # equivalent
xy_grid(d <- as.data.frame(m), gr = 3)  # equivalent
xy_grid(x2 ~ x1, data = d, gr = 3)      # equivalent
}
