% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-methods.R
\name{getSpnsAge}
\alias{getSpnsAge}
\title{Get age ranges for multiple nodes}
\usage{
getSpnsAge(tree, ids, ...)
}
\arguments{
\item{tree}{\code{TreeMan} object}

\item{ids}{vector of node ids}

\item{...}{\code{plyr} arguments}
}
\description{
Return start and end root to tip distances for \code{ids}.
}
\details{
Returns a dataframe, parallelizable.
}
\examples{
library(treeman)
tree <- randTree(10)
# all nodes but root
ids <- tree['nds'][tree['nds'] != tree['root']]
getSpnsAge(tree, ids=ids)
}
\seealso{
\code{\link{getNdAge}}, 
\code{\link{getNdsAge}}, 
\code{\link{getSpnAge}}, 
\url{https://github.com/DomBennett/treeman/wiki/get-methods}
}

