% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_multilocus.R
\name{retrieve_parent_genetrees}
\alias{retrieve_parent_genetrees}
\alias{get_parent_gts}
\alias{retrieve_child_genetrees}
\alias{get_child_gts}
\title{Retrieve all gene trees of the parent tree from a list generated from sim_mlc}
\usage{
retrieve_parent_genetrees(gene_tree_list)

get_parent_gts(gene_tree_list)

retrieve_child_genetrees(gene_tree_list)

get_child_gts(gene_tree_list)
}
\arguments{
\item{gene_tree_list}{A list of length 2: "parent_tree" and "child_trees" both of which are of class "multiPhylo"}
}
\value{
A `multiPhylo` object of only the gene trees generated on the parent subtree
}
\description{
Retrieve all gene trees of the parent tree from a list generated from sim_mlc

Retrieves the gene trees of the child subtrees
}
\section{Functions}{
\itemize{
\item \code{retrieve_child_genetrees}: Returns a list of objects of class `multiPhylo`
}}

\examples{
#' # first simulate a species tree
mu <- 0.5
lambda <- 1.0
nt <- 6
tr <- sim_stBD(sbr = lambda, sdr = mu, numbsim = 1, n_tips = nt)
# for a locus tree with 100 genes sampled per locus tree
gene_br <- 0.1
gene_dr <- 0.02
transfer_rate <- 0.2
locus_tree <- sim_ltBD(species_tree = tr[[1]],
                  gbr = gene_br,
                  gdr = gene_dr,
                  lgtr = transfer_rate,
                  num_loci = 1)
effect_popsize <- 1e6
gene_tree_obj <- sim_mlc(locus_tree[[1]],
                                      effect_popsize,
                                      num_reps = 2)
parent_trees <- retrieve_parent_genetrees(gene_tree_obj)
}
