% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_assoc_tab_to_mat.R
\name{convert_assoc_table_to_matrix}
\alias{convert_assoc_table_to_matrix}
\alias{make_mat}
\title{Convert a table with host and symbiont associations to a matrix}
\usage{
convert_assoc_table_to_matrix(assoc_table)

make_mat(assoc_table)
}
\arguments{
\item{assoc_table}{A dataframe with two columns}
}
\value{
A matrix with rows as symbionts and columns as hosts with 1's representing an association.
}
\description{
Converts a table of associations to an association matrix with rows as symbionts and columns as host.
}
\details{
Converts a dataframe with first column listing the host individually and the second column as the symbionts.
If hosts have more than one symbiont list these with commas.
For example, if the table is a tab-delimited file then a row should read:
"Hostus_mostus    Symbiont_1, Symbiont_2".
}
\examples{
file_path <- system.file("extdata",
                         "gopher_lice_mapping.txt",
                          package = "treeducken")
gopher_lice_map <- read.table(file_path,
                              stringsAsFactors = FALSE,
                              header = TRUE)
gopher_lice_assoc_matrix <- convert_assoc_table_to_matrix(gopher_lice_map)

}
