\docType{package}
\name{treecm-package}
\alias{treecm}
\alias{treecm-package}
\title{Assessment of the position of the centre of mass of trees}
\description{
  The centre of mass is a crucial data for arborists in
  order to consolidate a tree using steel or dynamic
  cables. Given field-recorded data on branchiness of a
  tree, the package: \itemize{ \item{computes and plots the
  centre of mass of the tree itself} \item{simulates the
  shift in CM position as branches are pruned}
  \item{computes branches slenderness coefficient in order
  to aid the arborist identify potentially dangerous
  branches} \item{computes the force acting on a ground
  plinth and its best position relating to the tree centre
  of mass, should the tree need to be stabilized by a steel
  cable} } The tree stem is ideally sectioned in logs. The
  weight of tree components is assessed based on \itemize{
  \item the sum of volume of stem logs \item the sum of
  branches biomass } Field measures to be taken on logs and
  branches are described in \code{\link{importFieldData}}
  and are to be recorded on the tree itself, possibly using
  tree-climbing tecniques. In order to help the arborist in
  the pruning selection process a simple plot of branch
  coefficient of slenderness is implemented.
}
\note{
  \bold{Branch biomass} is computed by allometric equations
  relating its fresh weight (wood + leaves) to its diameter
  at point of insertion on the stem. \bold{Log biomass} is
  computed by converting its volume to weight using wood
  fresh density. Volume is computed using Smalian's formula
  (see \code{\link{logBiomass}} description). A sample
  \code{.CSV} file is provided to guide through data
  filling in the field
}
\examples{
data(stonePine1TreeData)
vectors  <- treeVectors(stonePine1TreeData)
CM       <- centreOfMass(vectors)
plot(vectors,
   main = "Centre Of Mass",
   col = "grey30",
   txtcol = "grey30")
plot(CM)
summary(CM)
}
\author{
  Marco Bascietto \email{marco.bascietto@ibaf.cnr.it}
}
\references{
  Source code is hosted at GitHub
  (\url{http://mbask.github.com/treecm/})
}
\seealso{
  \code{\link{logBiomass}} \code{\link{importFieldData}}
}
\keyword{package}

