% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sShapeI.R
\name{sShapeI}
\alias{sShapeI}
\title{Calculation of the s-shape statistic for rooted trees}
\usage{
sShapeI(tree, logbase = 2)
}
\arguments{
\item{tree}{A rooted tree in phylo format.}

\item{logbase}{The logarithm base that shall be used.}
}
\value{
\code{sShapeI} returns the s-shape statistic of the given tree.
}
\description{
This function calculates the s-shape statistic \eqn{sShape(T)} for a given rooted
tree \eqn{T}. The tree must not necessarily be binary, however \eqn{sShape} only fulfils
the definition of an imbalance index on the space of binary trees. \eqn{sShape(T)} is defined as
\deqn{sShape(T)=\sum_{u\in V_{in}(T)} log(n_u-1)}{sShape(T)=\sum_{u in V_in(T)} log(n_u-1)} in
which \eqn{V_{in}(T)}{V_in(T)} denotes the set of inner vertices of \eqn{T}
and \eqn{n_u} denotes the number of leaves
in the pending subtree that is rooted at \eqn{u}. An arbitrary logarithm base can be used
(for binary trees it is common to use base 2).\cr\cr
For \eqn{n=1} the function returns \eqn{sShape(T)=0} and a warning.
}
\examples{
tree <- ape::read.tree(text="((((,),),(,)),(((,),),(,)));")
sShapeI(tree)

}
\references{
M.G. Blum and O. Francois. Which random processes describe the tree of life? a large-scale study of phylogenetic tree imbalance. Systematic Biology, 2006.
}
\author{
Luise Kuehn
}
