% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feed.R
\name{tr_real_long_term}
\alias{tr_real_long_term}
\title{Return the daily treasury real long-term rates}
\usage{
tr_real_long_term(date = NULL)
}
\arguments{
\item{date}{\code{character(1)} or \code{numeric(1)} date in format yyyy or yyyymm.
If \code{NULL}, all data is returned. Default \code{NULL}.}
}
\value{
A \code{data.frame()} with columns \code{date} and \code{rate} or \code{NULL} when no
entries where found.
}
\description{
Return the daily treasury real long-term rates
}
\examples{
\donttest{
# get data for a single month
tr_real_long_term("202201")
# or for the entire year
tr_real_long_term(2022)
}
}
\references{
\url{https://home.treasury.gov/treasury-daily-interest-rate-xml-feed}
}
\seealso{
Other treasury data: 
\code{\link{tr_bill_rates}()},
\code{\link{tr_long_term_rate}()},
\code{\link{tr_real_yield_curve}()},
\code{\link{tr_yield_curve}()}
}
\concept{treasury data}
