# transport

R package for solving a wide range of optimal transport problems, both balanced and unbalanced, with dedicated methods for 1-d transport, images, point masses in space and semidiscrete transport. You can compute Wassserstein distances and their underlying optimal transport plans and display the results graphically in a number of ways.


## Installation

Install the latest stable version from [CRAN](https://CRAN.R-project.org/package=transport) by saying in R
```r
install.packages("transport")
```
or install the development version from GitHub by saying in R
```r
remotes::install_github("dschuhmacher/transport")
```


## Getting started

Check the help page for `transport` and possibly `unbalanced`, `wasserstein` and `wasserstein1d`.


## History

The transport package was started in 2013 with two simple algorithms for optimal transport between images that were mainly intended for computations and evaluations of methods in the local research group. Since 2014, I have submitted new versions to [CRAN](https://CRAN.R-project.org/package=transport) on a regular basis. Over time the package has grown into a larger but somewhat unruly collection of methods and convenience functions with substantial code contributions from colleagues and staff members. I have finally created this GitHub repository in 2024 in order to collect more direct feedback and possibly some code contributions to help grinding down some of the rough edges and reaching version 1.0.


## Citation

Most of us have to justify the time they invest in their projects by some kind of performance measure. If you use this package in publications, please do cite it as

> D. Schuhmacher, B. Bähre, N. Bonneel, C. Gottschlich, V. Hartmann, F. Heinemann, B. Schmitzer and J. Schrieber (2024). *transport: Computation of Optimal Transport Plans and Wasserstein Distances.* R package version 0.15-0. <https://cran.r-project.org/package=transport>


## Contributions

Any contributions are welcome from filing individual bug reports (please give a reproducible example!) over suggestions for improvements to pull requests with new features. A more detailed guide for contributing will be added soon.
