% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hla_mismatch.R
\name{hla_mm_level_str}
\alias{hla_mm_level_str}
\title{HLA mismatch level from string}
\usage{
hla_mm_level_str(mm, sep = TRUE)
}
\arguments{
\item{mm}{character string vector of HLA mismatches, e.g. "1:1:0" or "211"}

\item{sep}{logical to indicate whether separator used in the HLA mismatch strings (default TRUE)}
}
\value{
numeric vector of HLA mismatch levels
}
\description{
Vectorised function to calculate HLA mismatch levels where the HLA A, B and DR mismatch is
recorded as a string rather than as separate numeric values, e.g. "1:0:1" or "101". The
function calculates the mismatch level as used in the UK national deceased donor kidney
matching scheme. By default, the function assumes a single separator character is used
between each of the three numbers in the mismatch; if not, set the sep parameter to FALSE.
This function needs the stringr package to be installed.
}
\details{
The HLA mismatch level is derived from UK kidney matching policies which can be found on the
NHS Blood & Transplant ODT website at www.odt.nhs.uk
}
\examples{
# using string of HLA mismatches with colons
hla_mm_level_str("1:1:0")

# using string of HLA mismatches without separator
hla_mm_level_str("211", sep = FALSE)
}
