% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-stop.R
\name{stops}
\alias{stops}
\alias{stopf}
\title{Throw Errors}
\usage{
stops(...)

stopf(fmt = "", ...)
}
\arguments{
\item{...}{Further arguments respectively passed to \code{\link[base:stop]{base::stop()}} and
\code{\link[base:sprintf]{base::sprintf()}} by \code{\link[=stops]{stops()}} and \code{\link[=stopf]{stopf()}}.}

\item{fmt}{A character of length 1 passed as is to \code{\link[base:sprintf]{base::sprintf()}}.}
}
\value{
Nothing. These functions are used for their side-effect of raising
an error.
}
\description{
\code{\link[=stops]{stops()}} is equivalent to \code{stop(..., call. = FALSE)}. It removes calls
from error messages by default. These are rarely useful and confuse users
more often than they help them.

\code{\link[=stopf]{stopf()}} is equivalent to \code{stops(sprintf(fmt, ...))}. It wraps
\code{\link[base:sprintf]{base::sprintf()}} and \code{\link[=stops]{stops()}} and is used to construct flexible
error messages.
}
\seealso{
Other utility functions: 
\code{\link{format_vector}()},
\code{\link{str_to}()},
\code{\link{vapply_1l}()}
}
\concept{utility functions}
\keyword{internal}
