#' Hashing
#'
#' @description
#' Map an arbitrary character string to a shorter string of hexadecimal
#' characters highly likely to be unique. It typically has a fixed width.
#'
#' **Arguments listed below are not validated for efficiency.**
#'
#' @details
#' Hashes generated by [hash()] uniquely identify the `lang` and `text` pair.
#' Values passed to these arguments are concatenated with a colon character for
#' hashing purposes.
#'
#' @param text A non-[NA][base::NA] character string. It can be empty.
#'
#' @template param-lang
#'
#' @template param-algorithm
#'
#' @returns
#' [hash()] returns a character string, or `NULL` if `algorithm` is not
#' supported.
#'
#' @seealso
#' [`Translator`][Translator],
#' [`Text`][Text],
#' [normalize()],
#' [constant()]
#'
#' @keywords internal
hash <- function(lang = "", text = "", algorithm = "") {
    x <- sprintf("%s:%s", lang, text)

    return(
        switch(algorithm,
            sha1 = digest::digest(
                charToRaw(x),
                algo      = "sha1",
                serialize = FALSE),
            utf8 = as.character(sum(cumsum(utf8ToInt(x)))),
            NULL))
}
