% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xpssTtest.R
\name{xpssTtest}
\alias{xpssTtest}
\title{Performs a T-Test}
\usage{
xpssTtest(x, variables = NULL, t_test = "testval", testval = NULL,
  criteria = 0.95, groupvar = NULL, groups = NULL, withvars = NULL,
  paired = FALSE, missing = "analysis")
}
\arguments{
\item{x}{a (non-empty) data.frame or input data of class \code{"xpssFrame"}.}

\item{variables}{atomic character or character vector with the names of the variables.}

\item{t_test}{atomic character definies the type of t-test. Default is \code{testval}, a one-sample t-test.
Optional arguments are \code{groups} for an independent-sample test and \code{pairs} for an paires-sample test}

\item{testval}{atomic numeric which indicates the value of mean difference.}

\item{criteria}{atomic numeric which specifies the confidence interval for the mean differences. Default
is \code{"0.95"}, optionally a customized value between 0 and 1 can be used.}

\item{groupvar}{atomic character with the name of the variable which shall be used for grouping.}

\item{groups}{factor variable which specify the variables grouped for an independentsample t-test.}

\item{withvars}{atomic characters or character vector with the name of the paired variables which shall be used for compare the means. Optionally
the argument \code{with} can be chosen to compare the means of 2 pairs.}

\item{paired}{logical. Indicating whether the comparison should be pair based or not.}

\item{missing}{atomic character determines the method which indicates what should happen when the data contains NAs. Default is analysis.
Optionally \code{include} oder \code{listwise} can be used.}
}
\value{
returns a list depending upon the t-test.

 All t-test contain: \cr
\tabular{rlll}{

\tab \code{statistics} \tab  simple statistics. \cr
\tab \code{parameter} \tab degrees of freedom. \cr
\tab \code{p.value} \tab significance level. \cr
\tab \code{conf.int} \tab confidence bound. \cr
\tab \code{null.value} \tab value of null hypothesis. \cr
\tab \code{alternative} \tab value of alternative hypothesis. \cr
\tab \code{method} \tab character string with the name of the t-test. \cr
\tab \code{data.name} \tab name of the data.}

The independent t-test includes additonally: \cr
\tabular{rlll}{

\tab \code{anova} \tab anova of the groups.}

The paired t-test includes additonally: \cr
\tabular{rlll}{

\tab \code{corr} \tab correlation of the pairs.}
}
\description{
R implementation of the SPSS \code{T-TEST} function.
}
\details{
Performs a Student's T-Test. The \code{xpssTtest} compares the mean by calculating Students-t of the selected distributions.

It is possible to check the samples.

\enumerate{
\item against a specific value (one-sample) -> \code{testval}
\item in difference of groups (independent-sample)-> \code{groups}
\item in difference of variables (paired-sample) -> \code{pairs}
 }

Simple statistics will be printed with every t-test.
At the one-sample test, the mean difference will be visualized with the statistics \cr
At the independend-sample test, the mean differnce and ANOVA will be visualized with the statistics \cr
At the paired-sample test, the mean diference and a correlation statistic will be visualizied with the statistics \cr
}
\examples{
data(fromXPSS)


xpssTtest(fromXPSS,
                   variables = "V7_2",
                   t_test = "testval",
                   testval= 50,
                   criteria = 0.65)

xpssTtest(fromXPSS,
                   t_test = "pairs",
                   variables=c("V5",
                               "V6",
                               "V7_1",
                               "V7_2"),
                   paired = FALSE,
                   missing = "analysis",
                   criteria = 0.85)

xpssTtest(fromXPSS,
                   variables = "V7_2",
                   t_test = "groups",
                   groupvar = "V3",
                   groups = c(1, 2),
                   missing = "analysis",
                   criteria = 0.99)
}
\author{
Bastian Wiessner
}

