% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xpssMeans.R
\name{xpssMeans}
\alias{xpssMeans}
\title{Simple descriptive statistics}
\usage{
xpssMeans(x, variables = NULL, by = NULL, missing = NULL,
  cells = "default", statistics = NULL)
}
\arguments{
\item{x}{a (non-empty) data.frame or input data of class \code{"xpssFrame"}.}

\item{variables}{atomic character or character vector with the name of the variables.}

\item{by}{atomic character or character vector with the name of the variables.}

\item{missing}{atomic numeric with the name of the missing method. Default is \code{NULL}. Optionally \code{table},\code{dependent} or \code{include} can be chosen. See note for more.}

\item{cells}{specifies descriptiv statistics for the results. Default is \code{mean}, \code{stddev} and \code{n}. See notes for more.}

\item{statistics}{specifies a anova or linearity test for each result. Default is \code{NULL}. Optionally \code{anova }can be chosen.}
}
\description{
R Implementation of the SPSS Function \code{MEANS}.
}
\details{
The xpssMeans function displays by default the mean, standard deviation and the amount of observations for a numeric dependent variable. and group counts for a string variable within groups defined by one or more control (independent) variables. Other procedures that display univariate statistics are SUMMARIZE, FREQUENCIES, and DESCRIPTIVES.

\strong{\code{missing:}}
\tabular{rll}{

\tab \code{table} \tab Deletes cases tablewise.
\cr \tab \code{include} \tab Include user-missing values.
\cr \tab \code{dependent} \tab Exclude user-missing values for dependent variables only.
}

\strong{\code{statistics:}}
\tabular{rll}{

\tab \code{anova} \tab calculates sumsquare, degrees of freedom, meansquare, f-value and significance level.
}
\strong{\code{cells:}}
\tabular{rll}{

\tab \code{all} \tab calculates all following descriptiv functions.
\cr \tab \code{count} \tab displays the amount of observations.
\cr \tab \code{first} \tab displays the first observation.
\cr \tab \code{geometric} \tab displays the geometric mean
\cr \tab \code{harmonic} \tab displays the harmonic mean
\cr \tab \code{kurt} \tab calculates the bulge of the variable.
\cr \tab \code{last} \tab displays the last observation.
\cr \tab \code{max} \tab displays the maximum of the variable.
\cr \tab \code{mean} \tab calculates the arithmetic mean, respectively the midpoint of the variable.
\cr \tab \code{median} \tab calculates the median of the variable.
\cr \tab \code{min} \tab displays the minimum of the variable.
\cr \tab \code{range} \tab displays the span between the minimum and the maximum value.
\cr \tab \code{sekurtosis} \tab calculates the standrard error of the bulge of the variable.
\cr \tab \code{semean} \tab displays the standard error of the arithmetic mean.
\cr \tab \code{seskewness} \tab calculates the standrard error of the inclination of the variable.
\cr \tab \code{skew} \tab calculates the inclination of the variable.
\cr \tab \code{stddev} \tab  displays the standard deviation of the variable.
\cr \tab \code{sum} \tab calculates the sum of each observation within the variable.
\cr \tab \code{variance} \tab displays the variance.}
}
\examples{
# mean of variable V3
xpssMeans(x=fromXPSS,variables="V3")

# mean of variable V3 and V4
xpssMeans(x=fromXPSS,variables=c("V3","V4"))

# mean of variable V3 and V6 by V4
xpssMeans(x=fromXPSS,variables=c("V3","V6"),by="V4")

# Filtering by V4 and calculate Mean of Variable V6 by V3 and V6_kl3
fromXPSS <- xpssFilter(x=fromXPSS,variable="V4",filtervalue=1)
xpssMeans(x=fromXPSS,variables="V6",by=c("V3","V6_kl3"))
fromXPSS <- xpssFilterOff(fromXPSS)
}
\author{
Bastian Wiessner
}

