% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xpssComputeDates.R
\name{computeCtime_days}
\alias{computeCtime_days}
\title{Calculates the difference of time between two dates  in days}
\usage{
computeCtime_days(x,date=NULL)
}
\arguments{
\item{x}{atomic object of class \code{character, POSIXlt  or  POSIXt} holding date data}

\item{date}{atomic object of class \code{character, POSIXlt  or  POSIXt} holding date data}
}
\value{
\code{computeCtime_days} returns the difference between x and date in days.
}
\description{
R Implementation of the SPSS \code{CTIME.DAYS} Function. \code{computeCtime_days} is a helper function for xpssCompute.
}
\details{
The input format of the date's is "YYYY-MM-DD" as Date, and with timeparameters YYYY-MM-DD HH:MM:SS.

\strong{Examples:}
\tabular{rlll}{
\tab Date w/o Time \tab Date with Time
\cr \tab YYYY-MM-DD \tab YYYY-MM-DD HH:MM:SS
\cr \tab 2015-01-01 \tab 2015-01-01 00:00:00
\cr \tab 2015-12-31 \tab 2015-12-31 23:59:59}

It is possible to calculate the difference between the dates, even if they do not have the same structure.
It is possible to match dates without time paramters, with dates which contain the time parameters. Additionally it is possible to match dates which are not in the right format.

\strong{Note:} The calculation of two dates, one with the format YYYY-MM-DD and the other one with the format DD-MM-YYYY is valid, but not recommended.
}
\examples{
xpssCompute(x="2013-09-14", fun="computeCtime_days", date="2013-09-11")
xpssCompute(x="2015-11-28", fun="computeCtime_days", date="2014-11-28")
}
\author{
Bastian Wiessner
}
\seealso{
\code{\link{difftime}} \code{\link{DateTimeClasses}} \code{\link{as.POSIXlt}} \code{\link{strptime}}
}
\keyword{internal}

