% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{TrajInPolygon}
\alias{TrajInPolygon}
\title{Test whether each of the points in a trajectory lie inside a polygon}
\usage{
TrajInPolygon(trj, boundary)
}
\arguments{
\item{trj}{Trajectory to test}

\item{boundary}{A polygon defining the region to be tested against. Can be
any structure that \code{\link{xy.coords}} can handle, such as a data frame
with \code{x} and \code{y} columns.}
}
\value{
Integer array with a value for each point in the trajectory. Values
  are: 0: point is strictly exterior to boundary; 1: point is strictly
  interior to boundary; 2: point lies on the relative interior of an edge of
  boundary; 3: point is a vertex of boundary
}
\description{
Simply a wrapper around \code{\link[sp]{point.in.polygon}}. The \code{sp}
package must be installed for this function to be called. \code{sp} is not
automatically installed as a dependency of trajr.
}
\examples{
# Square arena
boundary <- data.frame(x = c(-10, 10, 10, -10), y = c(-10, -10, 10, 10))

# Generate a random trajectory
set.seed(1)
trj <- TrajGenerate(n = 10, stepLength = 2, angularErrorSd = .15)

# Test which points lie inside the boundary
print(TrajInPolygon(trj, boundary))
## [1] 1 1 1 1 1 1 0 0 0 0 0

}
\seealso{
\code{\link[sp]{point.in.polygon}}, \code{\link{xy.coords}}
}
