% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ots_create_tidy_data.R
\name{ots_create_tidy_data}
\alias{ots_create_tidy_data}
\title{Downloads and processes the data from the API to return a human-readable tibble}
\usage{
ots_create_tidy_data(
  years = 2018,
  reporters = "usa",
  partners = "all",
  products = "all",
  sections = "all",
  groups = "all",
  table = "yr",
  max_attempts = 5,
  use_cache = FALSE,
  file = NULL,
  use_localhost = FALSE
)
}
\arguments{
\item{years}{Year contained within the years specified in
api.tradestatistics.io/year_range (e.g. \code{c(1980,1985)}, \code{c(1980:1981)} or \code{1980}).
Default set to \code{1962}.}

\item{reporters}{ISO code for reporter country (e.g. \code{"chl"}, \code{"Chile"} or
\code{c("chl", "Peru")}). Default set to \code{"all"}.}

\item{partners}{ISO code for partner country (e.g. \code{"chl"}, \code{"Chile"} or
\code{c("chl", "Peru")}). Default set to \code{"all"}.}

\item{products}{HS product codes (e.g. \code{"0101"}, \code{"01"} or search
matches for \code{"apple"})
to filter products. Default set to \code{"all"}.}

\item{sections}{unofficial product sections (e.g. \code{"01"} or search
matches for \code{"animals"}) to filter sections Default set to
\code{"all"}.}

\item{groups}{HS product groups (e.g. \code{"01"} or search matches for 
\code{"animals"}) to filter groups. Default set to \code{"all"}.}

\item{table}{Character string to select the table to obtain the data.
Default set to \code{yr} (Year - Reporter).
Run \code{ots_tables} in case of doubt.}

\item{max_attempts}{How many times to try to download data in case the
API or the internet connection fails when obtaining data. Default set
to \code{5}.}

\item{use_cache}{Logical to save and load from cache. If \code{TRUE}, the results will be cached in memory
if \code{file} is \code{NULL} or on disk if `file` is not \code{NULL}. Default set to \code{FALSE}.}

\item{file}{Optional character with the full file path to save the data. Default set to \code{NULL}.}

\item{use_localhost}{Logical to determine if the base URL shall be localhost instead
of api.tradestatistics.io. Default set to \code{FALSE}.}
}
\value{
A tibble that describes bilateral trade metrics (imports,
exports, trade balance and relevant metrics
such as exports growth w/r to last year) between a \code{reporter}
and \code{partner} country.
}
\description{
Accesses \code{api.tradestatistics.io} and
performs different API calls to transform and return tidy data.
}
\examples{
\dontrun{
# The next examples can take more than 5 seconds to compute,
# so these are just shown without evaluation according to CRAN rules

# Run `ots_countries` to display the full table of countries
# Run `ots_products` to display the full table of products

# What does Chile export to China? (1980)
ots_create_tidy_data(years = 1980, reporters = "chl", partners = "chn")

# What can we say about Horses export in Chile and the World? (1980)
ots_create_tidy_data(years = 1980, products = "0101", table = "yc")
ots_create_tidy_data(years = 1980, reporters = "chl", products = "0101", table = "yrc")

# What can we say about the different types of apples exported by Chile? (1980)
ots_create_tidy_data(years = 1980, reporters = "chl", products = "apple", table = "yrc")
}
}
\keyword{functions}
