% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Generics.R
\docType{methods}
\name{generateTags}
\alias{generateTags}
\alias{generateTags,ANY-method}
\title{customizing-metadata}
\usage{
generateTags(object)
}
\arguments{
\item{object}{The object to generate tags for}
}
\value{
A character vector of tags to associate with \code{object}
    during the recording process
}
\description{
The generateTags is called when extracting metadata
    from an object. It is one mechanism by which custom metadata
    can be defined on a class-by-class basis without the more
    heavy-weight solution of defining an entirely new FeatureSet
    subclass.
}
\details{
The upsides of this mechanism is that it is easier to use
    and lighter weight than defining new FeatureSet classes and
    methods to generate them. The downsides are that the metadata
    are tags, rather than proper key-value pairs, as far as trackr
    is concerned. (A backend could be engineered such that it
    interpreted tags of the form \code{'key:value'} as key-value
    pairs, but this won't occur without extra work, and thus those
    implied fields will not be queriable via the trackr api
    specifically. The values will be included in the metadata
    generally though, so non-field-specific queries will work.
}
\examples{
generateTags(mtcars) #character(0)
}
