% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reading.R, R/zzz_aliases.R
\name{read_container}
\alias{read_container}
\alias{readContainer}
\title{Read a GPS container file.}
\usage{
read_container(
  file,
  type = c("tcx", "gpx", "db3", "json"),
  table = "gps_data",
  timezone = "",
  session_threshold = 2,
  correct_distances = FALSE,
  smooth_elevation_gain = TRUE,
  country = NULL,
  mask = TRUE,
  from_distances = NULL,
  speedunit = NULL,
  distanceunit = NULL,
  sport = NULL,
  lgap = 30,
  lskip = 5,
  m = 11,
  silent = FALSE
)

readContainer(
  file,
  type = c("tcx", "gpx", "db3", "json"),
  table = "gps_data",
  timezone = "",
  session_threshold = 2,
  correct_distances = FALSE,
  smooth_elevation_gain = TRUE,
  country = NULL,
  mask = TRUE,
  from_distances = NULL,
  speedunit = NULL,
  distanceunit = NULL,
  sport = NULL,
  lgap = 30,
  lskip = 5,
  m = 11,
  silent = FALSE
)
}
\arguments{
\item{file}{The path to a tcx, gpx, json or db3 file. Compressed
versions (gz, bz2, xz, zip) of tcx, gpx, and json files are
directly supported.}

\item{type}{The type of the GPS container file. Supported so far
are \code{tcx}, \code{db3}, and \code{json}.}

\item{table}{The name of the table in the database if \code{type}
is set to \code{db3}, ignored otherwise.}

\item{timezone}{The timezone of the observations as passed on to
\code{\link[base]{as.POSIXct}}.  Ignored for JSON files.}

\item{session_threshold}{The threshold in hours for the time
difference between consecutive timestamps above which they are
considered to belong to different training sessions.}

\item{correct_distances}{Logical. Should the distances be corrected
for elevation? Default is \code{FALSE}.}

\item{smooth_elevation_gain}{Logical. Should the elevation gain be
smoothed before computing elevation gain? Default
is \code{TRUE}.}

\item{country}{ISO3 country code for downloading altitude data. If
\code{NULL}, country is derived from longitude and latitude}

\item{mask}{Logical. Passed on to
\code{\link[raster]{getData}}. Should only the altitudes for
the specified \code{country} be extracted (\code{TRUE}) or also
those for the neighbouring countries (\code{FALSE})?}

\item{from_distances}{Logical. Should the speeds be calculated from
the distance recordings instead of taken from the speed
recordings directly. Defaults to \code{TRUE} for \code{tcx} and
Golden Cheetah's json files and to \code{FALSE} for \code{db3}
files.}

\item{speedunit}{Character string indicating the measurement unit
of the speeds in the container file to be converted into meters
per second. Default is \code{m_per_s} when \code{type} is
\code{tcx} and \code{km_per_h} when \code{type} is \code{db3}
or \code{json}. See Details.}

\item{distanceunit}{Character string indicating the measurement
unit of the distance in the container file to be converted into
meters. Default is \code{m} when \code{type} is \code{tcx} and
\code{km} when \code{type} is \code{db3} or \code{json}. See
Details.}

\item{sport}{What sport does \code{file} contain data from? Either
\code{'cycling'}, \code{'running'}, \code{'swimming'} or
\code{NULL} (default), in which case the sport is directly
obtained from the \code{\link{readX}} extractors.}

\item{lgap}{Time in seconds corresponding to the minimal sampling rate.}

\item{lskip}{Time in seconds between the last observation before a small break
and the first imputed speed or the last imputed speed and the first
observation after a small break.}

\item{m}{Number of imputed observations in each small break.}

\item{silent}{Logical. Should warnings be generated if any of the
sanity checks on the data are triggered?}
}
\value{
An object of class \code{\link{trackeRdata}}.
}
\description{
Read a GPS container file.
}
\details{
Available options for \code{speedunit} currently are
\code{km_per_h}, \code{m_per_s}, \code{mi_per_h},
\code{ft_per_min} and \code{ft_per_s}.  Available options for
\code{distanceunit} currently are \code{km}, \code{m},
\code{mi} and \code{ft}.

\code{read_container} try to identify the sport from the data in
the container file. If that fails, then an attempt is made to guess
the sport from keywords in the filename. If identification is not
possible then an error is returned from
\code{\link{trackeRdata}}. To avoid that error, and if the sport is
known, append an appropriate keyword to the filename (e.g. 'ride',
'swim', 'run'). This should fix the error.
}
\examples{
filepath <- system.file("extdata/tcx", "2013-06-08-090442.TCX.gz", package = "trackeR")
run <- read_container(filepath, type = "tcx", timezone = "GMT")
}
\seealso{
\code{\link{trackeRdata}}, \code{\link{readTCX}}, \code{\link{readDB3}}, \code{\link{readJSON}}
}
