% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{readContainer}
\alias{readContainer}
\title{Read a GPS container file.}
\usage{
readContainer(file, type = c("tcx", "db3", "json"), table = "gps_data",
  timezone = "", sessionThreshold = 2, correctDistances = FALSE,
  country = NULL, mask = TRUE, fromDistances = NULL, speedunit = NULL,
  distanceunit = NULL, cycling = FALSE, lgap = 30, lskip = 5, m = 11,
  silent = FALSE, parallel = FALSE, cores = getOption("mc.cores", 2L))
}
\arguments{
\item{file}{The path to the file.}

\item{type}{The type of the GPS container file. Supported so far are \code{tcx}, \code{db3}, and \code{json}.}

\item{table}{The name of the table in the database if \code{type} is set to \code{db3},
ignored otherwise.}

\item{timezone}{The timezone of the observations as passed on to \code{\link[base]{as.POSIXct}}.
Ignored for JSON files.}

\item{sessionThreshold}{The threshold in hours for the time
difference between consecutive timestamps above which they are
considered to belong to different training sessions.}

\item{correctDistances}{Logical. Should the distances be corrected for elevation?}

\item{country}{ISO3 country code for downloading altitude data. If \code{NULL}, country is derived from
longitude and latitude.}

\item{mask}{Logical. Passed on to \code{\link[raster]{getData}}. Should only the altitudes for the specified
\code{country} be extracted (\code{TRUE}) or also those for the neighboring countries (\code{FALSE})?}

\item{fromDistances}{Logical. Should the speeds be calculated from the distance recordings
instead of taken from the speed recordings directly. Defaults to \code{TRUE} for \code{tcx}
and Golden Cheetah's json files and to \code{FALSE} for \code{db3} files.}

\item{speedunit}{Character string indicating the measurement unit of the speeds in the container
file to be converted into meters per second. Default is \code{m_per_s} when \code{type} is
\code{tcx} and \code{km_per_h} when \code{type} is \code{db3} or \code{json}. See Details.}

\item{distanceunit}{Character string indicating the measurement unit of the distance in the container
file to be converted into meters. Default is \code{m} when \code{type} is
\code{tcx} and \code{km} when \code{type} is \code{db3} or \code{json}. See Details.}

\item{cycling}{Logical. Do the data stem from cycling instead of running? If so, the unit of
measurement for cadence is set to \code{rev_per_min} instead of \code{steps_per_min}.}

\item{lgap}{Time in seconds corresponding to the minimal sampling rate.}

\item{lskip}{Time in seconds between the last observation before a small break
and the first imputed speed or the last imputed speed and the first
observation after a small break.}

\item{m}{Number of imputed observations in each small break.}

\item{silent}{Logical. Should warnings be generated if any of the sanity checks on the data are triggered?}

\item{parallel}{Logical. Should computation be carried out in parallel? (Not supported on Windows.)}

\item{cores}{Number of cores for parallel computing.}
}
\value{
An object of class \code{\link{trackeRdata}}.
}
\description{
Read a GPS container file.
}
\details{
Available options for \code{speedunit} currently are \code{km_per_h}, \code{m_per_s},
    \code{mi_per_h}, \code{ft_per_min} and \code{ft_per_s}.
    Available options for \code{distanceunit} currently are \code{km}, \code{m}, \code{mi} and
    \code{ft}.

    Reading Golden Cheetah's JSON files is experimental.
}
\examples{
\dontrun{
filepath <- system.file("extdata", "2013-06-08-090442.TCX", package = "trackeR")
run <- readContainer(filepath, type = "tcx", timezone = "GMT")
}
}
\seealso{
\code{\link{trackeRdata}}, \code{\link{readTCX}}, \code{\link{readDB3}}, \code{\link{readJSON}}
}
