% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapTrips.R
\name{mapTrips}
\alias{mapTrips}
\title{Make simple maps of foraging trips}
\usage{
mapTrips(trips, colony, IDs = NULL, colorBy = c("complete", "trip"))
}
\arguments{
\item{trips}{SpatialPointsDataFrame. Must be output of
\code{\link{tripSplit}} function).}

\item{colony}{data.frame. Containing 'Latitude' and 'Longitude' fields
specifying the central location(s) from which trips begin. If more than one
location, each row should correspond to an appropriate location (Lat/Lon) for
 each ID value in \emph{trips}.}

\item{IDs}{numeric vector. Sequence of numeric indices for the IDs you wish
to map. Max of 25.}

\item{colorBy}{character string. Either "complete" if trips are to be
coloured as complete or incomplete, or "trip" if trips are to be coloured by
trip ID.}
}
\value{
Returns a figure of facetted maps, each of which corresponds to a
level of ID in \emph{trips}.
}
\description{
\code{mapTrips} uses output from \code{tripSplit} to create maps illustrating
 movements for each ID.
}
\details{
This function only works with the output of \code{tripSplit}.
}
\examples{
## make some play data
dataGroup <- data.frame(Longitude = rep(c(1:10, 10:1), 2), 
                        Latitude =  rep(c(1:10, 10:1), 2),
                        ID = c(rep("A", 20), rep("B", 20)),
                        DateTime = format(
                        lubridate::ymd_hms("2021-01-01 00:00:00") +
                        lubridate::hours(0:19))
)
colony <- data.frame(
 Longitude = dataGroup$Longitude[1], Latitude = dataGroup$Latitude[1]
)
Trips <- tripSplit(dataGroup,
                   colony=colony,
                   innerBuff=2,
                   returnBuff=20,
                   duration=1,
                   nests = FALSE,
                   rmNonTrip = TRUE
)
## Visualize trips
mapTrips(Trips, colony)                   # add colony location to each facet
mapTrips(Trips, colony, colorBy = "trip") # color trips by their order

}
\seealso{
\code{\link{tripSplit}}
}
