% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_tcpl_based.R
\name{rank_tcpl}
\alias{rank_tcpl}
\title{function to calculate ranking score, TAA, med_diff, EC values based on tcpl hill model}
\usage{
rank_tcpl(tcpl_models, spid_chnm_table = NULL, med_taa = NULL,
  med_med_diff = NULL)
}
\arguments{
\item{tcpl_models}{the list object returned by 'fit_curve_tcpl' function}

\item{spid_chnm_table}{a reference table with 'spid' and the corresponding chemical name 'chnm' column,
and the CAS number 'casn' column.}

\item{med_taa}{the median TAA value from reference chemical, if not supplied, then ranking score won't be calculated.}

\item{med_med_diff}{the median Median-Difference from reference chemical, if not supplied, then ranking score won't be calculated.}
}
\value{
a dataframe containing ranking metrics for each chemical (spid)
}
\description{
calculate ranking score, TAA, med_diff, absolute EC values, AC50, based on the hill model in tcpl package
}
\examples{
## start with normalized data
demo_md <- fit_curve_tcpl(demo_mc_norm, assay_info =
list(prim_assay = "Primary", toxi_assay = "Cytotox"))
demo_rank <- rank_tcpl(demo_md)


## start from raw data
# define assay
assay_info <- list(prim_assay = "Primary",toxi_assay = "Cytotox")
# data normalization
demo_mc_norm <- normalize_per_plate(demo_mc, nctrl = "DMSO")
# filter out two test chemicals
demo_mc_norm <- dplyr::filter(demo_mc_norm, spid \%in\% c("TP0001502B05", "TP0001502B01"))
# fit curve with default 20\% threshold
demo_md <- fit_curve_tcpl(demo_mc_norm, assay_info)
# calculate TAA and Med_diff only
demo_rank <- rank_tcpl(demo_md, med_taa = NULL, med_med_diff = NULL)

## calculate ranking score with specified median TAA and meidan Med_Difference
demo_rank <- rank_tcpl(demo_md, med_taa = 150, med_med_diff = 92)

}
