% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/path-index.r
\name{paths_index}
\alias{paths_index}
\title{Compute index value for many histories.}
\usage{
paths_index(bases_list, index_f)
}
\arguments{
\item{bases_list}{list of histories produced by \code{\link{save_history}}}

\item{index_f}{index function to apply to each projection}
}
\description{
This is a convenience method that returns a data frame summarising the
index values for multiple tour paths.
}
\examples{
\dontrun{
holes1d <- guided_tour(holes(), 1)
# Perform guided tour 5 times, saving results
tries <- replicate(5, save_history(flea[, 1:6], holes1d), simplify = FALSE)
# Interpolate between target bases
itries <- lapply(tries, interpolate)

paths <- paths_index(itries, holes())
head(paths)

if (require(ggplot2)) {
  ggplot(data = paths, aes(x=step, y=value, group = try)) + geom_line()
  ggplot(data = paths, aes(x=step, y=improvement, group = try)) + geom_line()
}
}
}
\keyword{internal}
