% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_census_and_acs.R
\name{search_geoheaders}
\alias{search_geoheaders}
\title{Search geographic headers}
\usage{
search_geoheaders(survey, keyword = "*", view = TRUE)
}
\arguments{
\item{survey}{type of survey, either "decennial" or "acs".}

\item{keyword}{keyword in description or reference. The default "*" includes
all geoheaders.}

\item{view}{display the search result with View() if TRUE}
}
\value{
data.table matching the search criteria
}
\description{
Search in field reference or description of geographic header
with keyword in dataset \code{\link{dict_decennial_geoheader}} or
\code{\link{dict_acs_geoheader}}.
}
\examples{
# Change view = TRUE (default) to View the returned data.
# search geoheader that contains keyword "india" in decennial 2010
aaa <- search_geoheaders("decennial", "india", view = FALSE)

# search for lattitude
bbb <- search_geoheaders("decennial", "latitu", view = FALSE)


\dontrun{
  # browse all geoheaders in ACS in View()
  search_geoheaders("acs")
}

}
