% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.corpus.textmeta.R
\name{as.corpus.textmeta}
\alias{as.corpus.textmeta}
\title{Transform textmeta to corpus}
\usage{
as.corpus.textmeta(
  object,
  docnames = "id",
  docvars = setdiff(colnames(object$meta), "id"),
  metadoc = character(),
  ...
)
}
\arguments{
\item{object}{\code{\link{textmeta}} object}

\item{docnames}{Character: string with the column of \code{object$meta}
which should be kept as \code{\link[quanteda]{docnames}}.}

\item{docvars}{Character: vector with columns of \code{object$meta} which
should be kept as \code{\link[quanteda]{docvars}}.}

\item{metadoc}{Character: vector with columns of \code{object$meta} which
should be kept as \code{\link[quanteda]{metadoc}}.}

\item{...}{Additional parameters like \code{compress} for \code{\link[quanteda]{corpus}}.}
}
\value{
\code{\link[quanteda]{corpus}} object
}
\description{
Transfers data from a \code{\link{textmeta}} object to a
\code{\link[quanteda]{corpus}} object -  the way text data is stored in the
package \code{\link[quanteda]{quanteda}}.
}
\examples{
texts <- list(A="Give a Man a Fish, and You Feed Him for a Day.
 Teach a Man To Fish, and You Feed Him for a Lifetime",
 B="So Long, and Thanks for All the Fish",
 C="A very able manipulative mathematician, Fisher enjoys a real mastery
 in evaluating complicated multiple integrals.")

obj <- textmeta(meta=data.frame(id=c("A", "B", "C", "D"),
 title=c("Fishing", "Don't panic!", "Sir Ronald", "Berlin"),
 date=c("1885-01-02", "1979-03-04", "1951-05-06", "1967-06-02"),
 additionalVariable=1:4, stringsAsFactors=FALSE), text=texts)

corp <- as.corpus.textmeta(obj)
summary(corp)
}
\keyword{manip}
