% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qhadam.R
\name{optim_qhadam}
\alias{optim_qhadam}
\title{QHAdam optimization algorithm}
\usage{
optim_qhadam(
  params,
  lr = 0.01,
  betas = c(0.9, 0.999),
  eps = 0.001,
  nus = c(1, 1),
  weight_decay = 0,
  decouple_weight_decay = FALSE
)
}
\arguments{
\item{params}{List of parameters to optimize.}

\item{lr}{Learning rate (default: 1e-3)}

\item{betas}{Coefficients computing running averages of gradient
and its square (default: (0.9, 0.999))}

\item{eps}{Term added to the denominator to improve numerical
stability (default: 1e-8)}

\item{nus}{Immediate discount factors used to
estimate the gradient and its square
(default: (1.0, 1.0))}

\item{weight_decay}{Weight decay (L2 penalty) (default: 0)}

\item{decouple_weight_decay}{Whether to decouple the weight
decay from the gradient-based optimization step.}
}
\value{
A torch optimizer object implementing the \code{step} method.
}
\description{
R implementation of the QHAdam optimizer proposed
by Ma and Yarats(2019). We used the implementation available at
https://github.com/jettify/pytorch-optimizer/blob/master/torch_optimizer/qhadam.py.
Thanks to Nikolay Novik for providing the pytorch code.

The original implementation has been developed by Facebook AI
and is licensed using the MIT license.

From the the paper by Ma and Yarats(2019):
QHAdam is a QH augmented version of Adam, where we
replace both of Adam's moment estimators with quasi-hyperbolic terms.
QHAdam decouples the momentum term from the current gradient when
updating the weights, and decouples the mean squared gradients
term from the current squared gradient when updating the weights.
}
\examples{
if (torch::torch_is_installed()) {
# function to demonstrate optimization
beale <- function(x, y) {
    log((1.5 - x + x * y)^2 + (2.25 - x - x * y^2)^2 + (2.625 - x + x * y^3)^2)
 }
# define optimizer
optim <- torchopt::optim_qhadam
# define hyperparams
opt_hparams <- list(lr = 0.01)

# starting point
x0 <- 3
y0 <- 3
# create tensor
x <- torch::torch_tensor(x0, requires_grad = TRUE)
y <- torch::torch_tensor(y0, requires_grad = TRUE)
# instantiate optimizer
optim <- do.call(optim, c(list(params = list(x, y)), opt_hparams))
# run optimizer
steps <- 400
x_steps <- numeric(steps)
y_steps <- numeric(steps)
for (i in seq_len(steps)) {
    x_steps[i] <- as.numeric(x)
    y_steps[i] <- as.numeric(y)
    optim$zero_grad()
    z <- beale(x, y)
    z$backward()
    optim$step()
}
print(paste0("starting value = ", beale(x0, y0)))
print(paste0("final value = ", beale(x_steps[steps], y_steps[steps])))
}

}
\references{
Jerry Ma, Denis Yarats,
"Quasi-hyperbolic momentum and Adam for deep learning".
https://arxiv.org/abs/1810.06801
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}

Daniel Falbel, \email{daniel.falble@gmail.com}

Rolf Simoes, \email{rolf.simoes@inpe.br}

Felipe Souza, \email{lipecaso@gmail.com}

Alber Sanchez, \email{alber.ipia@inpe.br}
}
