% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backend-common.R
\name{torchaudio_load}
\alias{torchaudio_load}
\title{Load Audio File}
\usage{
torchaudio_load(
  filepath,
  out = NULL,
  normalization = NULL,
  channels_first = TRUE,
  duration = 0L,
  offset = 0L,
  unit = c("sample", "time"),
  signalinfo = NULL,
  encodinginfo = NULL,
  filetype = NULL
)
}
\arguments{
\item{filepath}{(str): Path to audio file}

\item{out}{(Tensor): An optional output tensor to use instead of creating one. (Default: \code{NULL})}

\item{normalization}{(NULL, bool, float or function): Optional normalization.
If boolean \code{TRUE}, then output is divided by \code{2^31}.
Assuming the input is signed 32-bit audio, this normalizes to \verb{[-1, 1]}.
If \code{numeric}, then output is divided by that number.
If \code{function}, then the output is passed as a paramete to the given function,
then the output is divided by the result.
If \code{NULL}, defaults to specific loader behaviour (Default: \code{NULL})}

\item{channels_first}{(bool): Set channels first or length first in result. (Default: \code{TRUE})}

\item{duration}{(int): Number of frames (or seconds) to load.  0 to load everything after the offset. (Default: \code{0})}

\item{offset}{(int): Number of frames (or seconds) from the start of the file to begin data loading. (Default: \code{0})}

\item{unit}{(str): "sample" or "time". If "sample" duration and offset will be interpreted as frames, and as seconds otherwise.}

\item{signalinfo}{(str): A sox_signalinfo_t type, which could be helpful if the
audio type cannot be automatically determined. (Default: \code{NULL})}

\item{encodinginfo}{(str): A sox_encodinginfo_t type, which could be set if the
audio type cannot be automatically determined. (Default: \code{NULL})}

\item{filetype}{(str): A filetype or extension to be set if sox cannot determine it
automatically. (Default: \code{NULL})}
}
\value{
\preformatted{list(Tensor, int): An output tensor of size `[C x L]` or `[L x C]` where
    L is the number of audio frames and
    C is the number of channels.
    An integer which is the sample rate of the audio (as listed in the metadata of the file)
}
}
\description{
Loads an audio file from disk into a tensor
}
\examples{
\dontrun{
if(torch::torch_is_installed()) {
mp3_filename <- system.file("sample_audio_2.mp3", package = "torchaudio")
data = torchaudio_load(mp3_filename)
print(data[[1]]$size())
norm_fun <- function(x) torch::torch_abs(x)$max()
data_vol_normalized = torchaudio_load(mp3_filename, normalization= norm_fun)
print(data_vol_normalized[[1]]$abs()$max())
}

}

}
