% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models-wavernn.R
\name{model_upsample_network}
\alias{model_upsample_network}
\title{UpsampleNetwork}
\usage{
model_upsample_network(
  upsample_scales,
  n_res_block = 10,
  n_freq = 128,
  n_hidden = 128,
  n_output = 128,
  kernel_size = 5
)
}
\arguments{
\item{upsample_scales}{the list of upsample scales.}

\item{n_res_block}{the number of ResBlock in stack.  (Default: \code{10})}

\item{n_freq}{the number of bins in a spectrogram.  (Default: \code{128})}

\item{n_hidden}{the number of hidden dimensions of resblock.  (Default: \code{128})}

\item{n_output}{the number of output dimensions of melresnet.  (Default: \code{128})}

\item{kernel_size}{the number of kernel size in the first Conv1d layer.  (Default: \code{5})}
}
\value{
Tensor shape:  (n_batch, n_freq, (n_time - kernel_size + 1) * total_scale),
(n_batch, n_output, (n_time - kernel_size + 1) * total_scale)
where total_scale is the product of all elements in upsample_scales.
}
\description{
Upscale the dimensions of a spectrogram.
Pass the input through the UpsampleNetwork layer.
}
\details{
forward param:
specgram  (Tensor): the input sequence to the UpsampleNetwork layer (n_batch, n_freq, n_time)
}
\examples{
if(torch::torch_is_installed()) {
 upsamplenetwork = model_upsample_network(upsample_scales=c(4, 4, 16))
 input = torch::torch_rand (10, 128, 10)  # a random spectrogram
 output = upsamplenetwork (input)  # shape: (10, 1536, 128), (10, 1536, 128)
}

}
