% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R
\name{torch_conv1d}
\alias{torch_conv1d}
\title{Conv1d}
\arguments{
\item{input}{NA input tensor of shape \eqn{(\mbox{minibatch} , \mbox{in\_channels} , iW)}}

\item{weight}{NA filters of shape \eqn{(\mbox{out\_channels} , \frac{\mbox{in\_channels}}{\mbox{groups}} , kW)}}

\item{bias}{NA optional bias of shape \eqn{(\mbox{out\_channels})}. Default: \code{None}}

\item{stride}{NA the stride of the convolving kernel. Can be a single number or      a one-element tuple \verb{(sW,)}. Default: 1}

\item{padding}{NA implicit paddings on both sides of the input. Can be a      single number or a one-element tuple \verb{(padW,)}. Default: 0}

\item{dilation}{NA the spacing between kernel elements. Can be a single number or      a one-element tuple \verb{(dW,)}. Default: 1}

\item{groups}{NA split input into groups, \eqn{\mbox{in\_channels}} should be divisible by      the number of groups. Default: 1}
}
\description{
Conv1d
}
\section{conv1d(input, weight, bias=None, stride=1, padding=0, dilation=1, groups=1) -> Tensor }{


Applies a 1D convolution over an input signal composed of several input
planes.

See \code{~torch.nn.Conv1d} for details and output shape.

.. include:: cudnn_deterministic.rst
}

\examples{
if (torch_is_installed()) {

filters = torch_randn(c(33, 16, 3))
inputs = torch_randn(c(20, 16, 50))
nnf_conv1d(inputs, filters)
}
}
