% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setters_and_getters.R
\name{get_genes_by_Gene_Symbol}
\alias{get_genes_by_Gene_Symbol}
\title{Get the genetic position of a gene by its gene name}
\usage{
get_genes_by_Gene_Symbol(genes, chr = NULL, build = 38)
}
\arguments{
\item{genes}{A string or vector of strings representing gene names, (e.g. "FTO") or  (c("FTO","NOD2"))}

\item{chr}{A string, search for the genes on this chromosome only, (e.g chr="chr1")}

\item{build}{A string, genome build, choose between builds 37 (GRCh37) and 38 (GRCh38) (default is 38)}
}
\value{
Dataframe of genes
}
\description{
\code{get_genes_by_Gene_Symbol()} Get genes by their gene symbol/name
Required parameters is on gene name or a vector of gene names
}
\examples{
\dontrun{
  get_genes_by_Gene_Symbol(c("FTO","THADA"))
}

}
