% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bart_tourney_results.R
\name{bart_tourney_results}
\alias{bart_tourney_results}
\title{Get NCAA Tournament Results}
\usage{
bart_tourney_results(
  min_year = 2000,
  max_year = current_season(),
  type = "team"
)
}
\arguments{
\item{min_year}{Minimum year to pull -- defaults to 2000 (YYYY).}

\item{max_year}{Maximum year to pull -- defaults to current season (YYYY).}

\item{type}{Data split value, defaults to team ('team', 'coach', 'conf',
'seed').}
}
\value{
Returns a tibble of adjusted and raw tournament results.
}
\description{
Returns a tibble with raw and adjusted NCAA tournament results by team,
coach, conference, or seed back to 2000.
}
\details{
\itemize{\item PASE is the number of wins above or below the expected value
given a seed. \item PAKE is the number of wins above or below the expected
value given a KenPom rating.}
}
\examples{
\donttest{try(bart_tourney_results(min_year=2010, max_year=2015, type='conf'))}

}
