% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bart_player_splits.R
\name{bart_player_splits}
\alias{bart_player_splits}
\title{Get Player Season Splits}
\usage{
bart_player_splits(
  year = current_season(),
  split = NULL,
  team = NULL,
  conf = NULL,
  exp = NULL,
  player_id = NULL,
  type = NULL
)
}
\arguments{
\item{year}{Year to filter.}

\item{split}{Split to filter (see details).}

\item{team}{Team to filter.}

\item{conf}{Conference to filter.}

\item{exp}{Experience to filter.}

\item{player_id}{Unique player ID to filter.}

\item{type}{Data type to return (see details).}
}
\value{
Returns a tibble with the number of columns dependent on the value
  supplied to the `stat` argument.
}
\description{
Returns season-long player statistics on a variety of splits.
}
\details{
Data is split on three statistical types, explained below: \describe{
\item{box}{Returns basic box score stats; sorts by ppg.}
\item{shooting}{Returns play-by-play shooting splits; sorts by ppg.}
\item{advanced}{Returns advanced metrics and possession-adjusted box score
statistics; sorts by recruiting rank.}}
}
\examples{
\donttest{try(bart_player_splits(year=2022, conf='ACC'))}

}
