% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_mosaic}
\alias{plot_mosaic}
\alias{plot_mosaic.tna}
\title{Create a Mosaic Plot of Transitions or Events}
\usage{
plot_mosaic(x, ...)

\method{plot_mosaic}{tna}(x, digits = 1, ...)
}
\arguments{
\item{x}{A \code{tna} or a \code{group_tna} object.}

\item{...}{Ignored.}

\item{digits}{An \code{integer} that determines the number of digits to use
for the chi-square test statistic and the p-value in the plot.}
}
\value{
A \code{ggplot} object.
}
\description{
Create a Mosaic Plot of Transitions or Events
}
\examples{
ftna_model <- ftna(group_regulation)
plot_mosaic(ftna_model)

}
\seealso{
Basic functions
\code{\link{build_model}()},
\code{\link{hist.group_tna}()},
\code{\link{hist.tna}()},
\code{\link{import_data}()},
\code{\link{plot.group_tna}()},
\code{\link{plot.tna}()},
\code{\link{plot_frequencies}()},
\code{\link{plot_frequencies.group_tna}()},
\code{\link{plot_mosaic.group_tna}()},
\code{\link{plot_mosaic.tna_data}()},
\code{\link{prepare_data}()},
\code{\link{print.group_tna}()},
\code{\link{print.summary.group_tna}()},
\code{\link{print.summary.tna}()},
\code{\link{print.tna}()},
\code{\link{print.tna_data}()},
\code{\link{simulate.tna}()},
\code{\link{summary.group_tna}()},
\code{\link{summary.tna}()},
\code{\link{tna-package}}
}
\concept{basic}
