% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modstats.R
\name{filterGS}
\alias{filterGS}
\alias{showModule}
\title{Filter by genes belonging to a gene set from a data frame}
\usage{
filterGS(genes, gs, mset = "all")

showModule(x, genes, gs, mset = "all", extra = NULL)
}
\arguments{
\item{genes}{a character vector with gene IDs}

\item{gs}{a character vector corresponding to the IDs of the gene sets to be shown}

\item{mset}{Module set to use; see "tmodUtest" for details}

\item{x}{a data frame or a vector}

\item{extra}{no longer used.}
}
\value{
filterGS returns a logical vector of length equal to genes, with
TRUE indicating that the given gene is a member of the gene sets in `gs`.
}
\description{
Filter a data frame or vector by genes belonging to a gene set
}
\details{
filterGS filters a vector of gene IDs based on whether the IDs belong to
a given set of gene sets, returning a logical vector.

The showModule function is deprecated and will be removed in future.
}
\examples{
data(Egambia)
## LI.M127 – type I interferon response
sel <- filterGS("LI.M127", Egambia$GENE_SYMBOL)
head(Egambia[sel, ])
}
