% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/line_functions.R
\name{offset_line}
\alias{double_line}
\alias{offset_line}
\title{Create a double line or offset line}
\usage{
offset_line(shp, offset)

double_line(shp, width, sides = "both")
}
\arguments{
\item{shp}{SpatialLines(DataFrame)}

\item{offset}{offset from the original lines}

\item{width}{width between the left and righthand side}

\item{sides}{character value that specifies which sides are selected: \code{"both"}, \code{"left"}, or \code{"right"}. The default is \code{"both"}. For the other two options, see also the shortcut function \code{offset_line}.}
}
\description{
Create a double line or offset line. The double line can be useful for visualizing two-way tracks or emulating objects such as railway tracks. The offset line can be useful to prevent overlapping of spatial lines.
}
\examples{
\dontrun{
if (require(tmap)) {
### Demo to visualise the route of the Amstel Gold Race, a professional cycling race
	tmpdir <- tempdir()
	tmpfile <- tempfile()
	download.file("http://www.gpstracks.nl/routes-fiets/f-limburg-amstel-gold-race-2014.zip",
				  tmpfile, mode="wb")
	unzip(tmpfile, exdir=tmpdir)

	# read GPX file
	AGR <- read_GPX(file.path(tmpdir, "f-limburg-amstel-gold-race-2014.gpx"))

	# read OSM of Zuid-Limburg
	Limburg_OSM <- read_osm(AGR$tracks, ext=1.05)

	# change route part names
	levels(AGR$tracks$name) <- paste(c("First", "Second", "Third", "Final"), "loop")
	AGR$tracks_offset2 <- offset_line(AGR$tracks, offset=c(.0005,0,-.0005,-.001))

	tm_shape(Limburg_OSM) +
		tm_raster(saturation=.25) +
	tm_shape(AGR$tracks_offset2) +
		tm_lines(col = "name", lwd = 4, title.col="Amstel Gold Race", palette="Dark2") +
	tm_shape(AGR$waypoints) +
		tm_bubbles(size=.1, col="gold", border.col = "black") +
		tm_text("name", size = .75, bg.color="white", bg.alpha=.25, auto.placement = .25) +
	tm_legend(position=c("right", "top"), frame=TRUE, bg.color = "gold") +
	tm_view(basemaps = "Esri.WorldTopoMap")

	# TIP: also run the plot in viewing mode, enabled with tmap_mode("view")
}
}
}

