% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/pkg.R
\name{tmap-element}
\alias{tmap-element}
\title{tmap element}
\description{
Building block for drawing thematic maps.
}
\details{
The only fundamental, and hence required element is
\itemize{
\item \code{\link{tm_shape}} that specifies the shape object, and also controls the projection and bounding box}

The elements that serve as drawing layers are
\itemize{
\item \code{\link{tm_borders}} to draw polygon borders
\item \code{\link{tm_fill}} to fill the polygons
\item \code{\link{tm_bubbles}} to draw bubbles
\item \code{\link{tm_lines}} to draw lines
\item \code{\link{tm_text}} to print text}

The layers can be stacked by simply adding them with the + symbol. The combination of the elements described above form one group. Multiple groups can be stacked. Each group should start with \code{\link{tm_shape}} (see examples below).

The layout elements are
\itemize{
\item \code{\link{tm_layout}} to change the appearance of the map, for instance titles, legend positions, and margins. Predefined themes for the example shape files are \code{\link{tm_layout_World}}, \code{\link{tm_layout_Europe}}, and \code{\link{tm_layout_NLD}}.
\item \code{\link{tm_facets}} that specifies how small multiples are created, i.e. how many rows and colums, and whether the statistical data variables have free scales or not.
\item \code{\link{tm_grid}} that specifies coordinate grid lines
}
}
\examples{
data(World)
data(Europe)
data(NLD_muni)
data(NLD_prov)
data(cities)

qtm(Europe)

qtm(World, fill = "economy", text="iso_a3", text.cex = "AREA", fill.palette="-Blues", 
	theme = "World", title="Economy")

tm_shape(World) +
	tm_fill("pop_est_dens", style="kmeans", palette="YlOrRd") +
	tm_borders() +
	tm_text("iso_a3", cex="AREA", cex.lowerbound=.4) +
	tm_layout_World(title="Population density per km2")

tm_shape(Europe) +
	tm_borders() +
	tm_fill() +
tm_shape(cities) +
	tm_bubbles(size="pop_max", col="capital", size.lim=c(0, 2e7)) +
	tm_text("name", cex="pop_max", scale=2, root=3, ymod=-.015, bg.alpha=0) +
	tm_layout_Europe("Metropolitan population", legend.titles=c(bubble.col="Capital"))

tm_shape(NLD_muni) +
	tm_borders() +
	tm_facets(by="province") +
	tm_fill("population", style="kmeans", convert2density = TRUE) +
	tm_shape(NLD_prov) +
	tm_borders(lwd=4) +
	tm_facets(by="name", free.coords=TRUE, drop.shapes=TRUE) +
	tm_layout(legend.show = FALSE)
}

