% Generated by roxygen2 (4.0.1): do not edit by hand
\name{tm_bubbles}
\alias{tm_bubbles}
\title{Draw bubble map}
\usage{
tm_bubbles(size = 1, col = "blueviolet", border.lwd = NA,
  border.col = "black", scale = 1, size.lim = NA, n = 5,
  style = "pretty", breaks = NULL, palette = NULL, labels = NULL,
  auto.palette.mapping = TRUE, contrast = 1, max.categories = 12,
  colorNA = "#FF1414", textNA = "Missing", xmod = 0, ymod = 0)
}
\arguments{
\item{size}{\code{shp} data variable that determines the bubble sizes. Multiple variable names create small multiples}

\item{col}{color(s) of the bubble. Either a color (vector), or categorical variable name(s). Multiple variable names create small multiples}

\item{border.lwd}{line width of the bubble borders. If \code{NA} (default), no bubble borders are drawn.}

\item{border.col}{color of the bubble borders.}

\item{scale}{bubble size multiplier number.}

\item{size.lim}{vector of two limit values of the \code{size} variable. Only bubbles are drawn whose value is greater than or equal to the first value. Bubbles whose values exceed the second value are drawn at the size of the second value. Only applicable when \code{size} is the name of a numeric variable of \code{shp}}

\item{n}{preferred number of color scale classes. Only applicable when \code{col} is a numeric variable name.}

\item{style}{method to cut the color scale: "fixed", "equal", "pretty", "quantile", "kmeans". Only applicable when \code{col} is a numeric variable name.}

\item{breaks}{in case \code{style=="fixed"}, breaks should be specified}

\item{palette}{color palette (see \code{RColorBrewer::display.brewer.all}) for the bubbles. Only when \code{col} is set to a variable.}

\item{labels}{labels of the classes}

\item{auto.palette.mapping}{When diverging colour palettes are used (i.e. "RdBu") this method automatically maps colors to values such that the middle colors (mostly white or yellow) are assigned to values of 0, and the two sides of the color palette are assigned to negative respectively positive values.}

\item{contrast}{number between 0 and 1 (default) that determines the contrast of the palette. Only applicable when \code{auto.palette.mapping=TRUE} and \code{col} is a numeric variable name.}

\item{max.categories}{in case \code{col} is the name of a categorical variable, this value determines how many categories (levels) it can have maximally. If the number of levels is higher than \code{max.categories}, then levels are combined.}

\item{colorNA}{colour for missing values}

\item{textNA}{text used for missing values. Use \code{NA} to omit text for missing values in the legend}

\item{xmod}{horizontal position modification of the bubbles, relatively where 0 means no modification, and 1 means the total width of the frame. Either a single number for all polygons, or a numeric variable in the shape data specifying a number for each polygon. Together with \code{ymod}, it determines position modification of the bubbles. In most coordinate systems (projections), the origin is located at the bottom left, so negative \code{xmod} move the bubbles to the left, and negative \code{ymod} values to the bottom.}

\item{ymod}{vertical position modification. See xmod.}
}
\value{
\code{\link{tmap-element}}
}
\description{
This layer speficies a bubble map. Both colors and sizes of the bubbles can be mapped to data variables.
}
\examples{
# World example
data(World)

tm_shape(World) +
    tm_fill() +
    tm_bubbles("pop_est") +
tm_layout_World("World population")

# Europe example
data(Europe)
data(cities)

tm_shape(Europe) +
    tm_borders() +
    tm_fill() +
tm_shape(cities) +
    tm_text("name", cex="pop_max", scale=2, root=3, ymod=-.015, bg.alpha=0) +
    tm_bubbles(size="pop_max", col="capital", size.lim=c(0, 2e7)) +
tm_layout_Europe("Metropolitan population", legend.titles=c(bubble.col="Capital"))


# Netherlands example
data(NLD_muni)
data(NLD_prov)

tm_shape(NLD_prov) +
    tm_borders() +
    tm_fill("name", palette="Pastel1") +
tm_shape(NLD_muni) +
    tm_bubbles(size="population", col="steelblue",style="kmeans") +
tm_layout_NLD(title="Population", legend.digits=0, legend.config="bubble.size", 
              legend.width=.4, bg.color="white")
}
\seealso{
\href{../doc/tmap-nutshell.html}{\code{vignette("tmap-nutshell")}}
}

