% Generated by roxygen2 (4.0.1): do not edit by hand
\name{qtm}
\alias{qtm}
\title{Quick thematic map plot}
\usage{
qtm(shp, fill = "grey90", bubble.size = NULL, bubble.col = NULL,
  text = NULL, text.cex = 1, line.lwd = NULL, line.col = NULL,
  borders = "grey40", theme = NULL, scale = 1, ...)
}
\arguments{
\item{shp}{shape object. For \code{\link{tm_fill}} and \code{\link{tm_bubbles}}, a \code{\link[sp:SpatialPolygonsDataFrame]{SpatialPolygonsDataFrame}} or a \code{\link[sp:SpatialPointsDataFrame]{SpatialPointsDataFrame}} is requied.
\code{\link[sp:SpatialPoints]{SpatialPoints}} and \code{\link[sp:SpatialPointsDataFrame]{SpatialPointsDataFrame}} are only used for \code{\link{tm_bubbles}}.}

\item{fill}{either a color to fill the polygons, or name of the data variable in \code{shp} to draw a choropleth.}

\item{bubble.size}{name of the data variable in \code{shp} for the bubblemap that specifies the sizes of the bubbles. If neither \code{bubble.size} nor \code{bubble.col} is specified, no bubblemap is drawn.}

\item{bubble.col}{name of the data variable in \code{shp} for the bubblemap that specifies the colors of the bubbles. If neither \code{bubble.size} nor \code{bubble.col} is specified, no bubblemap is drawn.}

\item{text}{Name of the data variable that contains the text labels.}

\item{text.cex}{Font size of the text labels. Either a constant value, or the name of a numeric data variable.}

\item{line.lwd}{either a line width or a name of the data variable that specifies the line width. Only applicable if \code{shp} is a \code{\link[sp:SpatialLines]{SpatialLines}} or \code{\link[sp:SpatialLinesDataFrame]{SpatialLinesDataFrame}}.}

\item{line.col}{either a line color or a name of the data variable that specifies the line colors. Only applicable if \code{shp} is a \code{\link[sp:SpatialLines]{SpatialLines}} or \code{\link[sp:SpatialLinesDataFrame]{SpatialLinesDataFrame}}.}

\item{borders}{color of the polygon borders. Use \code{NA} to omit the borders.}

\item{theme}{one of "World", "Europe", or "NLD"}

\item{scale}{numeric value that serves as the global scale parameter. All font sizes, bubble sizes, border widths, and line widths are controled by this value. The parameters \code{bubble.size}, \code{text.cex}, and \code{line.lwd} can be scaled seperately with respectively \code{bubble.scale}, \code{text.scale}, and \code{line.scale}.}

\item{...}{parameters passed on to the \code{tm_*} functions.}
}
\value{
\code{\link{tmap-element}}
}
\description{
This function is a convenient wrapper for drawing thematic maps quickly.
}
\examples{
# load shape objects
data(Europe)
data(World)

# just the map
qtm(Europe)

# choropleth
qtm(Europe, fill="gdp_cap_est", text="iso_a3", text.cex="pop_est", 
    title="GDP per capita", textNA="Non-European countries")

qtm(World, fill="pop_est_dens", theme="World", style="kmeans", title="Population per km")

# bubble map
qtm(Europe, bubble.size="pop_est", bubble.col="part", theme="Europe")

}
\seealso{
\href{../doc/tmap-nutshell.html}{\code{vignette("tmap-nutshell")}}
}

