% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type_abline.R, R/type_hline.R, R/type_vline.R
\name{type_abline}
\alias{type_abline}
\alias{type_hline}
\alias{type_vline}
\title{Add straight lines to a plot}
\usage{
type_abline(a = 0, b = 1)

type_hline(h = 0)

type_vline(v = 0)
}
\arguments{
\item{a, b}{the intercept (default: \code{a} = 0) and slope (default: \code{b} = 1)
terms. Numerics of length 1 or equal to the number of facets.}

\item{h}{y-value(s) for horizontal line(s). Numeric of length 1 or equal to
the number of facets.}

\item{v}{x-value(s) for vertical line(s). Numeric of length 1 or equal to the
number of facets.}
}
\description{
These functions add straight line(s) through the current plot.
}
\details{
Unlike most tinyplot types, \code{type_abline}, \code{type_hline}, and \code{type_vline}
cannot be called as a base plot layer. Instead they \emph{must} called as a
subsequent layer via \code{\link{tinyplot_add}}.
}
\examples{
#
## abline

tinyplot(x = -10:10, y = rnorm(21) + -10:10, grid = TRUE)
tinyplot_add(type = "abline")
# same as...
# tinyplot_add(type = type_abline(a = 0, b = 1))

# customize by passing bespoke intercept and slope values
tinyplot_add(type = type_abline(a = -1, b = -0.5))

#
## hline and vline

# Base plot layer
tinyplot(mpg ~ hp | cyl, facet = "by", data = mtcars, ylim = c(0, 40))

# Add horizontal lines at the (default) 0 y-intercept
tinyplot_add(type = "hline", col = "grey")

# Note that group+facet aesthetics will be inherited. We can use this to
# add customized lines (here: the mean `mpg` for each `cyl` group)  
tinyplot_add(type = type_hline(with(mtcars, tapply(mpg, cyl, mean))), lty = 2)

# Similar idea for vline
tinyplot_add(type = type_vline(with(mtcars, tapply(hp, cyl, mean))), lty = 2)

}
