% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type_summary.R
\name{type_summary}
\alias{type_summary}
\title{Plot summary values of \code{y} at unique values of \code{x}}
\usage{
type_summary(fun = mean, ...)
}
\arguments{
\item{fun}{summarizing function. Should be compatible with
\code{\link[stats]{ave}}. Defaults to \code{\link[base]{mean}}.}

\item{...}{Additional arguments are passed to the \code{lines()} function,
ex: \code{type="p"}, \code{col="pink"}.}
}
\description{
Applies a summary function to \code{y} along unique values of \code{x}. This is useful,
say, for quickly plotting mean values of your dataset. Internally,
\code{type_summary()} applies a thin wrapper around \code{\link[stats]{ave}} and
then passes the result to \code{\link{type_lines}} for drawing.
}
\examples{
# Plot the mean chick weight over time
tinyplot(weight ~ Time, data = ChickWeight, type = type_summary())

# mean is the default function, so the above is equivalent to
tinyplot(weight ~ Time, data = ChickWeight, type = type_summary(mean))

# Plot the median instead
tinyplot(weight ~ Time, data = ChickWeight, type = type_summary(median))

# Works with groups and/or facets too
tinyplot(weight ~ Time | Diet, facet = "by", data = ChickWeight, type = type_summary())

# Custom/complex function example
tinyplot(
  weight ~ Time | Diet, facet = "by", data = ChickWeight,
  type = type_summary(function(y) quantile(y, probs = 0.9)/max(y))
)

}
\seealso{
\code{\link{ave}} which performs the summarizing (averaging) behind the
scenes.
}
