% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logic_ops.R
\name{logic_ops}
\alias{logic_ops}
\alias{\%xor\%}
\alias{\%n&\%}
\alias{\%out\%}
\alias{\%?=\%}
\alias{\%=numtype\%}
\alias{\%=strtype\%}
\title{Additional Logic Operators}
\usage{
x \%xor\% y

x \%n&\% y

x \%out\% y

x \%?=\% y

n \%=numtype\% numtype

s \%=strtype\% strtype
}
\arguments{
\item{x, y}{see \link[base]{Logic}.}

\item{n}{a numeric vector.}

\item{numtype}{a single string giving the numeric type to be checked. \cr
See Details section for supported types.}

\item{s}{a character vector.}

\item{strtype}{a single string giving the string type to be checked. \cr
See Details section for supported types.}
}
\value{
A logical vector.
}
\description{
Additional logic operators: \cr
\cr
The \code{x \%xor\% y} operator is the "exclusive-or" operator, the same as \link{xor}\code{(x, y)}. \cr
\cr
The \code{x \%n&\%} operator is the "not-and" operator, the same as \code{(!x) & (!y)}. \cr
\cr
The \code{x \%out\% y} operator is the same as \code{!x \%in\% y}. \cr
\cr
The \code{x \%?=\% y} operator checks if \code{x} and \code{y}
are \strong{both} unreal or unknown (i.e. NA, NaN, Inf, -Inf). \cr
\cr
The \code{n \%=numtype\% numtype} operator checks
for every value of numeric vector \code{n}
if it can be considered a number belonging to type \code{numtype}. \cr
\cr
The \code{s \%=strtype\% strtype} operator checks
for every value of character vector \code{s}
if it can seen as a certain \code{strtype}. \cr
\cr
}
\details{
For argument \code{numtype}, the following options are supported: \cr
\itemize{
\item \code{"~0"}: zero, or else a number whose absolute value is smaller than the
Machine tolerance (\code{sqrt(.Machine$double.eps)}).
\item \code{"B"}: binary numbers (exactly 0 or exactly 1);
\item \code{"prop"}: proportions - numbers between 0 and 1 (exactly 0 or 1 is also allowed);
\item \code{"I"}: Integers;
\item \code{"odd"}: odd integers;
\item \code{"even"}: even integers;
\item \code{"R"}: Real numbers;
\item \code{"unreal"}: infinity, NA, or NaN; \cr \cr
}

For argument \code{strtype}, the following options are supported: \cr
\itemize{
\item \code{"empty"}: checks if the string only consists of empty spaces.
\item \code{"unreal"}: checks if the string is NA, or if it has literal string "NA", "NaN" or "Inf",
regardless if it has leading or trailing spaces.
\item \code{"numeric"}: checks if the string can be converted to a number,
disregarding leading and trailing spaces.
I.e. the string "5.0" can be converted to the the actual number \code{5.0}.
\item \code{"special"}: checks if the string consists of only special characters. \cr \cr
}
}
\examples{
x <- c(TRUE, FALSE, TRUE, FALSE, NA, NaN, Inf, -Inf, TRUE, FALSE)
y <- c(FALSE, TRUE, TRUE, FALSE, rep(NA, 6))
outcome <- data.frame(
  x=x, y=y,
  "x \%xor\% y"=x \%xor\% y, "x \%n&\% y" = x \%n&\% y, "x \%?=\% y" = x \%?=\% y,
  check.names = FALSE
)
print(outcome)

1:3 \%out\% 1:10
1:10 \%out\% 1:3


n <- c(0:5, 0:-5, 0.1, -0.1, 0, 1, Inf, -Inf, NA, NaN)
1e-20 \%=numtype\% "~0"
n[n \%=numtype\% "B"]
n[n \%=numtype\% "prop"]
n[n \%=numtype\% "I"]
n[n \%=numtype\% "odd"]
n[n \%=numtype\% "even"]
n[n \%=numtype\% "R"]
n[n \%=numtype\% "unreal"]

s <- c(" AbcZ123 ", " abc ", " 1.3 ", " !#$\%^&*() ", "  ", "  NA  ", "  NaN  ", " Inf ")
s[s \%=strtype\% "empty"]
s[s \%=strtype\% "unreal"]
s[s \%=strtype\% "numeric"]
s[s \%=strtype\% "special"]



}
