% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/5_get_deg_all.R
\name{get_deg_all}
\alias{get_deg_all}
\title{get_deg_all}
\usage{
get_deg_all(
  exp,
  group_list,
  ids,
  logFC_cutoff = 1,
  pvalue_cutoff = 0.05,
  adjust = FALSE,
  entriz = TRUE,
  scale_before = FALSE,
  n_cutoff = 3,
  cluster_cols = TRUE,
  annotation_legend = FALSE,
  show_rownames = FALSE,
  legend = FALSE,
  lab = NA,
  pkg = 4,
  symmetry = FALSE,
  heat_union = TRUE,
  heat_id = 1,
  gene_number = 200,
  color_volcano = c("#2874C5", "grey", "#f87669")
)
}
\arguments{
\item{exp}{A numeric matrix}

\item{group_list}{A factor with duplicated character or factor}

\item{ids}{a data.frame with 2 columns,including probe_id and symbol}

\item{logFC_cutoff}{Cutoff value of logFC,1 by default.}

\item{pvalue_cutoff}{Cutoff value of pvalue,0.05 by default.}

\item{adjust}{a logical value, would you like to use adjusted pvalue to draw this plot,FAlSE by default.}

\item{entriz}{logical , if TRUE ,convert symbol to entriz id.}

\item{scale_before}{deprecated parameter}

\item{n_cutoff}{3 by defalut , scale before plot and set a cutoff,usually 2 or 1.6}

\item{cluster_cols}{if F,heatmap will nor cluster in column}

\item{annotation_legend}{logical,show annotation legend or not}

\item{show_rownames}{logical,show rownames or not}

\item{legend}{logical,show legend or not}

\item{lab}{label for  x axis in volcano plot}

\item{pkg}{a integer ,means which Differential analysis packages you used,we support three packages by now, 1,2,3,4 respectively means "DESeq2","edgeR","limma(voom)","limma"}

\item{symmetry}{a logical value ,would you like to get your plot symmetrical}

\item{heat_union}{logical ,use union or intersect DEGs for heatmap}

\item{heat_id}{id of heatmap,1 for all DEGs,2 for head and tail,3 for top n DEGs}

\item{gene_number}{how many DEGs will heatmap show .}

\item{color_volcano}{color for volcano plot}
}
\value{
a list with deg data.frame, volcano plot ,pca plot ,heatmap and a list with DEGs.
}
\description{
do diffiencial analysis according to exprission set and group information
}
\examples{
\donttest{
gse = "GSE42872"
geo = geo_download(gse,destdir=tempdir(),by_annopbrobe = FALSE)
group_list = rep(c("A","B"),each = 3)
group_list = factor(group_list)
find_anno(geo$gpl)
ids <- AnnoProbe::idmap(geo$gpl,destdir = tempdir())
dcp = get_deg_all(geo$exp,group_list,ids)
head(dcp$deg)
dcp$plots
}
}
\seealso{
\code{\link{get_deg}};\code{\link{multi_deg_all}}
}
\author{
Xiaojie Sun
}
