% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/year_month.R
\name{year_month}
\alias{year_month}
\alias{year_quarter}
\alias{YM}
\alias{year_month_decimal}
\alias{YQ}
\alias{year_quarter_decimal}
\title{Fast methods for creating year-months and year-quarters}
\usage{
year_month(x)

year_quarter(x)

YM(length = 0L)

year_month_decimal(x)

YQ(length = 0L)

year_quarter_decimal(x)
}
\arguments{
\item{x}{A \code{year_month}, \code{year_quarter}, or any other time-based object.}

\item{length}{Length of \code{year_month} or \code{year_quarter}.}
}
\description{
These are experimental methods for working with year-months and
year-quarters inspired by 'zoo' and 'tsibble'.
}
\details{
The biggest difference is that the underlying data is simply
the number of months/quarters since epoch. This makes integer
arithmetic very simple, and allows for fast sequence creation as well as
fast coercion to \code{year_month} and \code{year_quarter}
from numeric vectors.

Printing method is also fast.
}
\examples{
library(timeplyr)
library(lubridate)

x <- year_month(today())

# Adding 1 adds 1 month
x + 1
# Adding 12 adds 1 year
x + 12
# Sequence of yearmonths
x + 0:12

# If you unclass, do the same arithmetic, and coerce back to year_month
# The result is always the same
year_month(unclass(x) + 1)
year_month(unclass(x) + 12)

# Initialise a year_month or year_quarter to the specified length
YM(0)
YQ(0)
YM(3)
YQ(3)

}
