% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_is_regular.R
\name{time_is_regular}
\alias{time_is_regular}
\title{Is time a regular sequence? (Experimental)}
\usage{
time_is_regular(
  x,
  time_by = NULL,
  g = NULL,
  use.g.names = TRUE,
  na.rm = TRUE,
  time_type = getOption("timeplyr.time_type", "auto"),
  allow_gaps = TRUE,
  allow_dups = TRUE
)
}
\arguments{
\item{x}{A vector. Can be a
\code{Date}, \code{POSIXt}, \code{numeric}, \code{integer}, \code{yearmon}, or \code{yearqtr}.}

\item{time_by}{Time unit. \cr
Must be one of the three:
\itemize{
\item string, specifying either the unit or the number and unit, e.g
\code{time_by = "days"} or \code{time_by = "2 weeks"}
\item named list of length one, the unit being the name, and
the number the value of the list, e.g. \code{list("days" = 7)}.
For the vectorized time functions, you can supply multiple values,
e.g. \code{list("days" = 1:10)}.
\item Numeric vector. If time_by is a numeric vector and x is not a date/datetime,
then arithmetic is used, e.g \code{time_by = 1}.
}}

\item{g}{Grouping object passed directly to \code{collapse::GRP()}.
This can for example be a vector or data frame. \cr
Note that when \code{g} is supplied the output is a logical with length
matching the number of unique groups.}

\item{use.g.names}{Should the result include group names?
Default is \code{TRUE}.}

\item{na.rm}{Should \code{NA} values be removed before calculation?
Default is \code{TRUE}.}

\item{time_type}{If "auto", \code{periods} are used for
the time expansion when days, weeks,
months or years are specified, and \code{durations}
are used otherwise. If \code{durations}
are used the output is always of class \code{POSIXt}.}

\item{allow_gaps}{Should gaps be allowed? Default is \code{TRUE}.}

\item{allow_dups}{Should duplicates be allowed? Default is \code{TRUE}.}
}
\value{
A logical vector the same length as the number of supplied groups.
}
\description{
This function is a fast way to check if a time vector
is a regular sequence, possibly for many groups.
Regular in this context means that the lagged time differences are a
whole multiple of the specified time unit. \cr
This means \code{x} can be a regular sequence with or without gaps in time.
}
\examples{
library(timeplyr)
library(lubridate)
library(dplyr)
\dontshow{
.n_dt_threads <- data.table::getDTthreads()
.n_collapse_threads <- collapse::get_collapse()$nthreads
data.table::setDTthreads(threads = 2L)
collapse::set_collapse(nthreads = 1L)
}
x <- 1:5
y <- c(1, 1, 2, 3, 5)

time_is_regular(x)
time_is_regular(y)

increment <- 1

# No duplicates allowed
time_is_regular(x, increment, allow_dups = FALSE)
time_is_regular(y, increment, allow_dups = FALSE)

# No gaps allowed
time_is_regular(x, increment, allow_gaps = FALSE)
time_is_regular(y, increment, allow_gaps = FALSE)

# Grouped
eu_stock <- ts_as_tibble(EuStockMarkets)
eu_stock <- eu_stock \%>\%
  mutate(date = as_date(
    date_decimal(time)
  ))

time_is_regular(eu_stock$date, g = eu_stock$group,
                time_by = 1)
# This makes sense as no trading occurs on weekends and holidays
time_is_regular(eu_stock$date, g = eu_stock$group,
                time_by = 1,
                allow_gaps = FALSE)
\dontshow{
data.table::setDTthreads(threads = .n_dt_threads)
collapse::set_collapse(nthreads = .n_collapse_threads)
}
}
